#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;

#endregion



#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		
		private Wealth102TC[] cacheWealth102TC;
		private Wealth101TS[] cacheWealth101TS;

		
		public Wealth102TC Wealth102TC()
		{
			return Wealth102TC(Input);
		}

		public Wealth101TS Wealth101TS()
		{
			return Wealth101TS(Input);
		}


		
		public Wealth102TC Wealth102TC(ISeries<double> input)
		{
			if (cacheWealth102TC != null)
				for (int idx = 0; idx < cacheWealth102TC.Length; idx++)
					if ( cacheWealth102TC[idx].EqualsInput(input))
						return cacheWealth102TC[idx];
			return CacheIndicator<Wealth102TC>(new Wealth102TC(), input, ref cacheWealth102TC);
		}

		public Wealth101TS Wealth101TS(ISeries<double> input)
		{
			if (cacheWealth101TS != null)
				for (int idx = 0; idx < cacheWealth101TS.Length; idx++)
					if ( cacheWealth101TS[idx].EqualsInput(input))
						return cacheWealth101TS[idx];
			return CacheIndicator<Wealth101TS>(new Wealth101TS(), input, ref cacheWealth101TS);
		}

	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		
		public Indicators.Wealth102TC Wealth102TC()
		{
			return indicator.Wealth102TC(Input);
		}

		public Indicators.Wealth101TS Wealth101TS()
		{
			return indicator.Wealth101TS(Input);
		}


		
		public Indicators.Wealth102TC Wealth102TC(ISeries<double> input )
		{
			return indicator.Wealth102TC(input);
		}

		public Indicators.Wealth101TS Wealth101TS(ISeries<double> input )
		{
			return indicator.Wealth101TS(input);
		}
	
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		
		public Indicators.Wealth102TC Wealth102TC()
		{
			return indicator.Wealth102TC(Input);
		}

		public Indicators.Wealth101TS Wealth101TS()
		{
			return indicator.Wealth101TS(Input);
		}


		
		public Indicators.Wealth102TC Wealth102TC(ISeries<double> input )
		{
			return indicator.Wealth102TC(input);
		}

		public Indicators.Wealth101TS Wealth101TS(ISeries<double> input )
		{
			return indicator.Wealth101TS(input);
		}

	}
}

#endregion
